/*
  - ------------------------------------------------------------------------ -
    Dalek model for POVray 2

    Scale - 1 unit = 1 cm
    
    Sample scene file - Created by Tom Rathborne - (c)1995

    For more information, see dalek.txt or this URL:
        http://www.uunet.ca/~tomr/pics/dalek/
  - ------------------------------------------------------------------------ -
*/

#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"

// use the sample rotations and textures (required before dalek.inc)

#include "dr-samp.inc"
#include "dt-samp.inc"

// get the Dalek.

#include "dalek.inc"

// look along the Z axis.

camera {
    direction <0.0, 0.0, 1.0>
    up <0.0, 1.0, 0.0>
    right <4/3, 0.0, 0.0>
    translate < 0, 70, -300.0>
    look_at <0.0, 70, 0.0>
}

// We want the tunnel to fade away.

fog {
    color Black
    distance 1000
}

// light it up!

light_source {
    <50, 100, -400>
    color White
}

light_source {
    <-100, 100, -800>
    color rgb <0.75, 0.75, 0.75>
}

// The star of the scene

object {
    Dalek
    rotate <0, -10, 0>
    translate <0, 72.5, 0> // stand Dalek right on top of <0, 0, 0>
}

// Dr. Who-style tunnel

object {
    Cylinder_Z
    scale <200, 200, 1>
    translate <0, 70, 0>
    texture {
        Apocalypse
        scale <16, 16, 64>
    }
}
