/*
  - ------------------------------------------------------------------------ -
    Dalek model for POVRay 2

    Scale - 1 unit = 1 cm
    
    Main include file - Created by Tom Rathborne - (c)1995

    For more information, see dalek.txt or this URL:
        http://www.uunet.ca/~tomr/pics/dalek/
  - ------------------------------------------------------------------------ -
*/

/*
    The object 'Dalek' will create a Dalek at the following location:

    Top of head: <0, 83, 0> (approximately! A rotated Antenna may be higher.)
    Top of body: <0, 0, 0>
    Bottom     : <0, -72.5, 0>

    The Dalek requires the following textures:
        Dalek_Texture
        Dalek_Balls_Texture
        Dalek_Chrome_Texture
        Dalek_Ant_fins_Texture

    The following rotations should also be defined:
        Dalek_Ant_Rotation       (x scalar)
        Dalek_Head_Rotation      (z scalar)
        Dalek_Arm_Angle          <x, y, z>
        Dalek_Exterminator_Angle <x, y, z>
*/

#include "dal-head.inc"
#include "dal-neck.inc"
#include "dal-shou.inc"
#include "dal-body.inc"

#declare Dalek = union {
    object {
        Dalek_Head
        translate <0, 62.75, 0>
        rotate <0, Dalek_Head_Rotation, 0>
    }

    object {
        Dalek_Neck
        translate <0, 40, 0>
    }

    object {
        Dalek_Shoulders
        translate <0, -0.25, 0>
    }

    object {
        Dalek_Body
        translate <0, 0, 0>
    }
}
