/*
  - ------------------------------------------------------------------------ -
    Dalek model for POVRay 2

    Scale - 1 unit = 1 cm
    
    Shoulders include file - Created by Tom Rathborne - (c)1995

    For more information, see dalek.txt or this URL:
        http://www.uunet.ca/~tomr/pics/dalek/
  - ------------------------------------------------------------------------ -
*/

#declare Dalek_Shoulders_Inner = object {
    union {
        difference {
            cone {
                <0 0 0> 31.25
                <0 41 0> 27.5
                scale <1 1 1.12>
            }
            plane {
                <0, 0, 1>, 0
            }
        }
        difference {
            cone {
                <0 0 0> 31.25
                <0 41 0> 27.5
            }
            plane {
                <0, 0, -1>, 0
            }
        }
    }
    texture { Dalek_Texture }
}
#declare Dalek_Shoulders_TopCollar = object {
    difference {
    union {
        difference {
            cone {
                <0 15.5 0> 32.25
                <0 34 0> 30.5
                scale <1 1 1.12>
            }
            plane {
                <0, 0, 1>, 0
            }
        }
        difference {
            cone {
                <0 15.5 0> 32.25
                <0 34 0> 30.5
            }
            plane {
                <0, 0, -1>, 0
            }
        }
    }

    box {
        <-24, 0, -40>, <24, 19.1, 2>
    }

    }
    texture {
        material_map {
            gif "dal-mesh.gif"
            map_type 2
            texture {
                pigment { color rgb <0.1 0.1 0.1> quick_color White }
                finish { specular 0.2 roughness 0.25 }
            }
            texture { pigment { color Clear quick_color White } }
        }
        scale <400 400 400>
    }
}

#declare Dalek_Shoulders_BottomCollar = object {
    difference {
    intersection {
        union {
           difference {
                cone {
                    <0, -1, 0> 36.5
                    <0, 41, 0> 29.5
                    scale <1 1 1.12>
                }
                plane {
                    <0, 0, 1>, 0
                }
            }
            difference {
                cone {
                    <0, -1, 0> 36.5
                    <0, 41, 0> 29.5
                }
                plane {
                    <0, 0, -1>, 0
                }
            }
        }
        plane {
            <0, 1, 0>, 12
        }
    }
    box {
        <-24, 3, -40>, <24, 15, 2>
    }
    }
    texture { Dalek_Chrome_Texture }
}

#declare Dalek_Arm_Mount = object {
    union {
        object {
            sphere { <0, 0, 0> 4.75 }
            texture {
                pigment { color rgb < 0.1 0.1 0.1 > quick_color White }
                finish { specular 0.1 roughness 0.5 }
            }
        }
        object {
            box { <-6.25, -6.25, -1.5>, <6.25, 6.25, 20> }
            texture { Dalek_Texture }
        }
    }
    rotate <8 0 0>
}

#declare Dalek_Arm = object {
    union {
        object { union {
        object {
            Disk_Z
            scale <2 2 20>
            translate <0, 0, -20>
            texture { Dalek_Chrome_Texture }
        }
        object {
            Disk_Z
            scale <1.75 1.75 25>
            translate <0, 0, -25>
            texture { Dalek_Chrome_Texture }
        }
        object {
            union {
                difference {
                    difference {
                        object { sphere { <0 0 0> 6 } }
                        object { sphere { <0 0 0> 5.5 } }
                    }
                    plane { <0,0,1>, 0 }
                }
                object {
                    torus { 5.75, 0.25 }
                    rotate <90 0 0>
                }
            }
            texture { 
                pigment {
                    color rgb <0.2, 0.2, 0.2>
                    quick_color White
                }
                finish { Dull }
            }
            scale <1 1 0.5>
            translate <0, 0, -53>
        }
        }
        rotate Dalek_Arm_Angle
        }
        object { Dalek_Arm_Mount }
    }
    translate <-16, 11.25, -32>
}

#declare Dalek_Exterminator_Rod = object {
    union {
          object {
              Disk_Z
              scale <0.3 0.3 14.75>
              translate <0, 2.3, -22.3>
          }
          object {
              Disk_Y
              scale <0.3 0.75 0.3>
              translate <0, 1.55, -7.55>
          }
          object {
              sphere {<0 0 0> 0.3}
              translate <0 2.3, -7.55>
          }
          object {
              Disk_Y
              scale <0.3 0.75 0.3>
              translate <0, 1.55, -37.05>
          }
          object {
              sphere {<0 0 0> 0.3}
              translate <0 2.3, -37.05>
          }
    }
    texture { Brass_Texture pigment { quick_color White } }
}

#declare Dalek_Exterminator = object {
    union {
        object { union {
            object {
                difference {
                    union {
                        object {
                            Disk_Z
                            scale <1.3 1.3 19.025>
                            translate <0, 0, -19.025>
                            texture { Dalek_Chrome_Texture }
                        }
                        object {
                            Disk_Z
                            scale <1.1 1.1 10>
                            translate <0, 0, -33>
                            texture { 
                                pigment {color rgb <0.1, 0.1, 0.1>
                                   quick_color White }
                                finish { Dull }
                            }
                        }
                    }
                    object {
                        Disk_Z
                        scale <0.9 0.9 10>
                        translate <0, 0, -34>
                        texture { 
                            pigment {color rgb <0.1, 0.1, 0.1>
                                   quick_color White }
                            finish { Dull }
                        }
                    }
                }
            }
    
            object {
                Disk_Z
                scale <1.4 1.4 0.5>
                translate <0,0,-37.05>
                texture { Brass_Texture pigment { quick_color White } }
            }
    
            object {
                Disk_Z
                scale <1.4 1.4 0.5>
                translate <0,0,-7.55>
                texture { Brass_Texture  pigment { quick_color White } }
            }
    
            object { Dalek_Exterminator_Rod rotate <0 0 0> }
            object { Dalek_Exterminator_Rod rotate <0 0 45> }
            object { Dalek_Exterminator_Rod rotate <0 0 90> }
            object { Dalek_Exterminator_Rod rotate <0 0 135> }
            object { Dalek_Exterminator_Rod rotate <0 0 180> }
            object { Dalek_Exterminator_Rod rotate <0 0 225> }
            object { Dalek_Exterminator_Rod rotate <0 0 270> }
            object { Dalek_Exterminator_Rod rotate <0 0 315> }
        }
        bounded_by { Disk_Z scale <2.5 2.5 40> translate <0, 0, -40> }
        rotate Dalek_Exterminator_Angle
        }
        object { Dalek_Arm_Mount }
    }
    translate <16, 11.25, -32>
}

#declare Dalek_Shoulders = object {
    union {
        object { Dalek_Shoulders_Inner }
        object { Dalek_Shoulders_TopCollar }
        object { Dalek_Shoulders_BottomCollar }
        object { Dalek_Arm }
        object { Dalek_Exterminator }
    }
}
