/*
  - ------------------------------------------------------------------------ -
    Dalek model for POVRay 2

    Scale - 1 unit = 1 cm
    
    Neck include file - Created by Tom Rathborne - (c)1995

    For more information, see dalek.txt or this URL:
        http://www.uunet.ca/~tomr/pics/dalek/
  - ------------------------------------------------------------------------ -
*/

#declare Dalek_Neck_Pole = object {
    Disk_Y
    scale <0.6 11.75 0.6>
    translate <25.1 11.75 0>
}

#declare Dalek_Neck_Rings = object {
    difference {
        merge {
            cone { <0 0 0> 31 <0 1.5 0> 29.5 }
            cone { <0 8 0> 30.25 <0 9.5 0> 28.75 }
            cone { <0 16 0> 29.5 <0 17.5 0> 28.0 }
            object { Dalek_Neck_Pole rotate <0 0 0> }
            object { Dalek_Neck_Pole rotate <0 45 0> }
            object { Dalek_Neck_Pole rotate <0 90 0> }
            object { Dalek_Neck_Pole rotate <0 135 0> }
            object { Dalek_Neck_Pole rotate <0 180 0> }
            object { Dalek_Neck_Pole rotate <0 225 0> }
            object { Dalek_Neck_Pole rotate <0 270 0> }
            object { Dalek_Neck_Pole rotate <0 315 0> }
        }
        object {
            Disk_Y
            scale <24.25 12 24.25>
            translate <0 12 0>
        }
    }
    texture { Dalek_Chrome_Texture }
}

#declare Dalek_Neck_Mesh = object {
    Disk_Y

    texture {
        material_map {
            gif "dal-mesh.gif"
            map_type 2
            texture {
                pigment { color rgb <0.1 0.1 0.1> quick_color White }
                finish { specular 0.2 roughness 0.25 }
            }
            texture { pigment { color Clear quick_color White } }
        }
        scale <10 10 10>
    }

    scale <24 11.75 24>
    translate <0 11.75 0>
}

#declare Dalek_Neck_Inside = object {
    Disk_Y

    texture {
        pigment { color rgb <0.025 0.025 0.025> quick_color White }
        finish { specular 0.1 roughness 0.5 }
    }

    scale <23 11.75 23>
    translate <0 11.75 0>
}

#declare Dalek_Neck = object {
union {
    object { Dalek_Neck_Rings }
    object { Dalek_Neck_Mesh }
    object { Dalek_Neck_Inside }
}
bounded_by { Disk_Y scale <31 16 31> translate <0 16 0>}
}
