/*
  - ------------------------------------------------------------------------ -
    Dalek model for POVRay 2

    Scale - 1 unit = 1 cm
    
    Head include file - Created by Tom Rathborne - (c)1995

    Note that the light sources in the orange
    bulbs on the head are commented out. Search for 'NOLIGHTS'...

    For more information, see dalek.txt or this URL:
        http://www.uunet.ca/~tomr/pics/dalek/
  - ------------------------------------------------------------------------ -
*/

#declare Dalek_Dome = object {
    difference {
    intersection {
        union {
            sphere { 
                <0, 0, 0> 27
               scale <1, (203/270), 1>
            }
            sphere { 
                <0, 0, 0> 27
                scale <2, 0.2, 2>
            }
        }
        cone {
            <0, 1.5*(82/38)*27.2, 0> 0
            <0, 0, 0> 27.2 
        }
    }

    box {
        <-1.6, 8.2, -30>, <1.6, 20, -14>
    }
    }

    texture { Dalek_Texture }
    bounded_by { sphere { <0,0,0> 28 } }
}

#declare Dalek_Dome_Light = object {
// NOLIGHTS - the 3 '*' comments remove the light sources from the lamps.
// *    union {
        cone { <25 0 0> 2 <27 0.75 0> 1
            texture {
                pigment { color rgbf <1.0 0.75 0 0.75>
                          quick_color White }
                finish { Shiny }
            }
// *        }
// *        light_source { <26.5 0 0> color rgb <1.0 1.0 0.5> }
    }
    rotate <0 0 30>
    translate <0, -1, 0>
}

#declare Dalek_Ant_eye_Texture = texture {
    pigment {
        color rgb <0.2, 0.2, 0.2>
        quick_color White
    }
    finish {
        Shiny
    }
}

#declare Dalek_AntClip = 4.4167

#declare Dalek_Antenna = object {
    union {
        // base
        object {
            intersection {
                object {
                    Disk_X
                    scale <1.6, 5.1, 5.1>
                }
                plane {
                    <0, 0, -1>, Dalek_AntClip
                }
            }
            texture { Dalek_Chrome_Texture }
        }
        //shaft
        object {
            Disk_Z
            scale <1.35, 1.35, (23.5/2)>
            translate <0, 0, -((23.5/2)+(Dalek_AntClip-0.5))>
            texture { Dalek_Chrome_Texture }
        }
        // disk-fins
        union {
            object {
                Disk_Z
                scale <4.75, 4.75, 0.15>
                translate <0, 0, -18.4167>
            }
            object {
                Disk_Z
                scale <5, 5, 0.15>
                translate <0, 0, -19.9167>
            }
            object {
                Disk_Z
                scale <4.5, 4.5, 0.15>
                translate <0, 0, -21.4167>
            }
            object {
                Disk_Z
                scale <3.5, 3.5, 0.15>
                translate <0, 0, -22.9167>
            }
            texture { Dalek_Ant_fins_Texture }
        }
        //eye & eyeball
        union {
        //eyeball
        object {
            intersection {
                sphere { <0 0 0> 5 }
                difference {
                    union {
                        cone { <0, 0, 0> 5 <0, 0, -1> 4 }
                        object {
                            Disk_Z
                            scale <5 5 2.5>
                            translate <0 0 2.5>
                        }
                    }
                    object {
                        Disk_Z
                        scale <3.8 3.8 0.5>
                        translate <0, 0, -1>
                    }
                }
            }
            texture { Dalek_Ant_eye_Texture }
        }
        //eye
        object {
            Disk_Z
            scale <3.7 3.7 0.25>
            texture {
                pigment {
                    onion
                    color_map {
                      [0.0 color Black]
                      [0.5625 color Black]
                      [0.56251 color White]
                      [0.78125 color White]
                      [0.781251 color Black]
                    }
                    turbulence 0.0
                    scale <2.6, 2.6, 1.0>
                    translate <0, 0, -0.4>
                    quick_color White
                }
                finish { Shiny }
            }
            translate <0, 0, -0.75>
        }
        translate <0, 0, -30.4167>
    }
    }
    bounded_by {
        Disk_Z
        scale <5 5 25>
        translate <0, 0, -15>
    }
}

#declare Dalek_Head =
union {
    object { Dalek_Dome }
    object { Dalek_Dome_Light }
    object { Dalek_Dome_Light rotate <0 180 0> }
    object { Dalek_Antenna
        rotate <Dalek_Ant_Rotation 0 0>
        translate <0, 10, -17>
    }
}
