/*
  - ------------------------------------------------------------------------ -
    Dalek model for POVRay 2

    Scale - 1 unit = 1 cm
    
    Body include file - Created by Tom Rathborne - (c)1995

    For more information, see dalek.txt or this URL:
        http://www.uunet.ca/~tomr/pics/dalek/
  - ------------------------------------------------------------------------ -
*/

#declare Dalek_Body_Panels = object {
    intersection {
        // top and bottom
        plane { <0, -1, 0>, 71.5 }
        plane { <0, 1, 0>, 0 }

        // sides - starting at the back.
        plane { <0 0 1>, 0
            rotate <-4 0 0>
            translate <0 0 34.642>
        }

        plane { <0 0 1>, 0 
            rotate <-7.942 0 0>
            rotate <0, 45 0>
            translate <52.142,0,0>
        }
        plane { <0 0 1>, 0 
            rotate <-7.942 0 0>
            rotate <0, -45 0> 
            translate <-52.142,0,0>
        }
        plane { <0 0 1>, 0 
            rotate <-11.848 0 0>
            translate <0 0 31.642>
            rotate <0, 90 0>
        }
        plane { <0 0 1>, 0 
            rotate <-11.848 0 0>
            translate <0 0 31.642>
            rotate <0, -90 0>
        }
        plane { <0 0 1>, 0 
            rotate <-14.598 0 0>
            rotate <0, 105 0>
            translate <31.642,0,0>
        }
        plane { <0 0 1>, 0 
            rotate <-14.598 0 0>
            rotate <0, -105 0>
            translate <-31.642,0,0>
        }
        plane { <0 0 1>, 0 
            rotate <-17.348 0 0>
            rotate <0, 135 0>
            translate <26.466, 0, -19.3185>
        }
        plane { <0 0 1>, 0 
            rotate <-17.348 0 0>
            rotate <0, -135 0>
            translate <-26.466, 0, -19.3185>
        }

        plane { <0 0 1>, 0 
            rotate <-20.098 0 0>
            translate <0 0 33>
            rotate <0, 165 0>
        }
        plane { <0 0 1>, 0 
            rotate <-20.098 0 0>
            translate <0 0 33>
            rotate <0, -165 0>
        }   
    }
    texture { Dalek_Texture }
}

#declare Dalek_Body_Base = object {
    intersection {
        // top and bottom
        plane { <0, -1, 0>, 72.5 }
        plane { <0, 1, 0>, -71 }

        // sides - starting at the back.
        plane { <0 0 1>, 0
            rotate <-4 0 0>
            translate <0 0 34.642>
        }

        plane { <0 0 1>, 0 
            rotate <-7.942 0 0>
            rotate <0, 45 0>
            translate <52.142,0,0>
        }
        plane { <0 0 1>, 0 
            rotate <-7.942 0 0>
            rotate <0, -45 0> 
            translate <-52.142,0,0>
        }
        plane { <0 0 1>, 0 
            rotate <-11.848 0 0>
            translate <0 0 31.642>
            rotate <0, 90 0>
        }
        plane { <0 0 1>, 0 
            rotate <-11.848 0 0>
            translate <0 0 31.642>
            rotate <0, -90 0>
        }
        plane { <0 0 1>, 0 
            rotate <-14.598 0 0>
            rotate <0, 105 0>
            translate <31.642,0,0>
        }
        plane { <0 0 1>, 0 
            rotate <-14.598 0 0>
            rotate <0, -105 0>
            translate <-31.642,0,0>
        }
        plane { <0 0 1>, 0 
            rotate <-17.348 0 0>
            rotate <0, 135 0>
            translate <26.466, 0, -19.3185>
        }
        plane { <0 0 1>, 0 
            rotate <-17.348 0 0>
            rotate <0, -135 0>
            translate <-26.466, 0, -19.3185>
        }

        plane { <0 0 1>, 0 
            rotate <-20.098 0 0>
            translate <0 0 33>
            rotate <0, 165 0>
        }
        plane { <0 0 1>, 0 
            rotate <-20.098 0 0>
            translate <0 0 33>
            rotate <0, -165 0>
        }   
    }
    scale <1.05 1.0 1.05>
    texture {
        pigment {
            color rgb <0.2, 0.2, 0.2>
            quick_color White
        }
        finish {
            Dull
        }
    }
}


#declare Dalek_Body_Ball_Row = union {
    sphere { <0, -12, 0> 5 }
    sphere { <0, -29, 0> 5 }
    sphere { <0, -46, 0> 5 }
    sphere { <0, -63, 0> 5 }
}

#declare Dalek_Body_Balls = object {
    union {
        object { Dalek_Body_Ball_Row
            rotate <0 0, -4>
            rotate <-4 0 0>
            translate <-6 0 34.642>
        }
        object { Dalek_Body_Ball_Row
            rotate <0 0 4>
            rotate <-4 0 0>
            translate <6 0 34.642>
        }

        object { Dalek_Body_Ball_Row 
            rotate <0 0, 5> // something
            rotate <-7.942 0 0>
            rotate <0, 45, 0>
            translate <24.571,0,27.571>
        }
        object { Dalek_Body_Ball_Row 
            rotate <0 0, -5> // something 
            rotate <-7.942 0 0>
            rotate <0, -45 0> 
            translate <-24.571,0,27.571>
        }

        object { Dalek_Body_Ball_Row 
            rotate <0 0, 6> // something
            rotate <-11.848 0 0>
            rotate <0, 90 0>
            translate <31.642 0 10.25>
        }
        object { Dalek_Body_Ball_Row 
            rotate <0 0, -6> // something
            rotate <-11.848 0 0>
            rotate <0, -90 0>
            translate <-31.642 0 10.25>
        }

        object { Dalek_Body_Ball_Row 
            rotate <0 0, 8> // something
            rotate <-14.598 0 0>
            rotate <0, 105 0>
            translate <29.5395,0,-9.65925>
        }
        object { Dalek_Body_Ball_Row 
            rotate <0 0, -8> // something
            rotate <-14.598 0 0>
            rotate <0, -105 0>
            translate <-29.5395,0,-9.65925>
        }

        object { Dalek_Body_Ball_Row 
            rotate <0 0, 4>
            rotate <-17.348 0 0>
            rotate <0, 135 0>
            translate <20.1017, 0, -25.6825>
        }
        object { Dalek_Body_Ball_Row 
            rotate <0 0, -4>
            rotate <-17.348 0 0>
            rotate <0, -135 0>
            translate <-20.1017,0, -25.6825>
        }

        object { Dalek_Body_Ball_Row 
            rotate <-20.098 0 0>
            rotate <0, 165 0>
            translate <6.519999 0, -33.793467>
        }
        object { Dalek_Body_Ball_Row 
            rotate <-20.098 0 0>
            rotate <0, -165 0>
            translate <-6.519999 0, -33.793467>
        }   

    }
    texture { Dalek_Balls_Texture }
}

#declare Dalek_Body = object { union {
    object { Dalek_Body_Panels }
    object { Dalek_Body_Base }
    object { Dalek_Body_Balls }
}
    bounded_by { cone { <0 0 0> 75 <0, -73 0> 150 } }
}
